/*
 * Decompiled with CFR 0.152.
 */
package br.com.biscoitoback.backbiscoito.controller;

import br.com.biscoitoback.backbiscoito.model.Testador;
import br.com.biscoitoback.backbiscoito.service.TestadorService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/testadores"})
public class TestadorController {
    @Autowired
    private TestadorService testadorService;

    @GetMapping
    public ResponseEntity<List<Testador>> listarTestadores() {
        List testadores = this.testadorService.listarTestadores();
        return new ResponseEntity((Object)testadores, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Testador> buscarTestadorPorId(@PathVariable Long id) {
        Optional testador = this.testadorService.buscarTestadorPorId(id);
        return testador.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Testador> cadastrarTestador(@RequestBody Testador testador) {
        Testador testadorSalvo = this.testadorService.salvarTestador(testador);
        return new ResponseEntity((Object)testadorSalvo, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Testador> atualizarTestador(@PathVariable Long id, @RequestBody Testador testadorAtualizado) {
        Optional testador = this.testadorService.buscarTestadorPorId(id);
        if (testador.isPresent()) {
            Testador testadorExistente = (Testador)testador.get();
            testadorExistente.setEmail(testadorAtualizado.getEmail());
            Testador testadorSalvo = this.testadorService.salvarTestador(testadorExistente);
            return ResponseEntity.ok((Object)testadorSalvo);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletarTestador(@PathVariable Long id) {
        if (this.testadorService.existeTestador(id)) {
            this.testadorService.deletarTestador(id);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

