/*
 * Decompiled with CFR 0.152.
 */
package br.com.biscoitoback.backbiscoito.service;

import br.com.biscoitoback.backbiscoito.model.Usuario;
import br.com.biscoitoback.backbiscoito.repository.UsuarioRepository;
import br.com.biscoitoback.backbiscoito.service.AsaasIntegrationService;
import br.com.biscoitoback.backbiscoito.service.EmailService;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuarioService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private AsaasIntegrationService asaasIntegrationService;
    @Autowired
    private EmailService emailService;

    public List<Usuario> listarUsuarios() {
        return this.usuarioRepository.findAll();
    }

    public Optional<Usuario> buscarUsuarioPorId(Long id) {
        return this.usuarioRepository.findById((Object)id);
    }

    public Usuario salvarUsuario(Usuario usuario) {
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    public void deletarUsuario(Long id) {
        this.usuarioRepository.deleteById((Object)id);
    }

    public boolean existeUsuario(Long id) {
        return this.usuarioRepository.existsById((Object)id);
    }

    public Usuario cadastrarUsuario(Usuario usuario) throws Exception {
        Usuario savedUser = (Usuario)this.usuarioRepository.save((Object)usuario);
        savedUser.setStatusPagamento("PAGO");
        savedUser = (Usuario)this.usuarioRepository.save((Object)savedUser);
        this.emailService.sendWelcomeEmail(savedUser.getEmail(), savedUser.getNome());
        return savedUser;
    }

    public void solicitarResetSenha(String email) throws Exception {
        Usuario usuario = (Usuario)this.usuarioRepository.findByEmail(email);
        if (usuario == null) {
            throw new Exception("E-mail n\u00e3o encontrado");
        }
        String resetCode = this.generateResetCode();
        usuario.setResetCode(Integer.parseInt(resetCode));
        this.usuarioRepository.save((Object)usuario);
        this.emailService.sendPasswordResetEmail(email, usuario.getNome(), resetCode);
    }

    private String generateResetCode() {
        SecureRandom random = new SecureRandom();
        int code = random.nextInt(900000) + 100000;
        return String.valueOf(code);
    }

    public boolean alterarSenha(String email, int resetCode, String novaSenha) throws Exception {
        Usuario usuario = (Usuario)this.usuarioRepository.findByEmail(email);
        if (usuario != null && usuario.getResetCode() == resetCode) {
            String encryptedPassword = new BCryptPasswordEncoder().encode((CharSequence)novaSenha);
            usuario.setSenha(encryptedPassword);
            usuario.setResetCode(0);
            this.usuarioRepository.save((Object)usuario);
            return true;
        }
        return false;
    }
}

